<?php

/**
 * Get all blocks NAME from folder
 */
function che_get_all_dir( $dir ): array {
	return array_map( function ( $dir ) {
		return basename( $dir );
	}, che_get_all_dir_path( $dir ) );
}

/**
 * Get all blocks PATH from folder
 */
function che_get_all_dir_path( $dir ): array {
	return glob( $dir . '/*', GLOB_ONLYDIR );
}

/**
 * Add header and footer logos to the Customizer.
 */
function che_customize_register( $wp_customize ) {
	// Add Header Logo Setting.
	$wp_customize->add_setting( 'header_logo', [
		'default'   => '',
		'transport' => 'refresh',
	] );

	// Add Header Logo Control.
	$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'header_logo', [
		'label'       => __( 'Additional Header Logo', 'general' ),
		'section'     => 'title_tagline', // Section: Site Identity
		'settings'    => 'header_logo',
		'description' => __( 'Upload a logo specifically for the header.', 'general' ),
		'priority'    => 8,
	] ) );

	// Add Footer Logo Setting.
	$wp_customize->add_setting( 'footer_logo', [
		'default'   => '',
		'transport' => 'refresh',
	] );

	// Add Footer Logo Control.
	$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'footer_logo', [
		'label'       => __( 'Footer Logo', 'general' ),
		'section'     => 'title_tagline', // Section: Site Identity
		'settings'    => 'footer_logo',
		'description' => __( 'Upload a logo specifically for the footer.', 'general' ),
		'priority'    => 8,
	] ) );
}
add_action( 'customize_register', 'che_customize_register' );