<?php

function che_wp_enqueue_scripts_theme(){

    /**
     * Register js scripts
     */
	foreach ( che_general_config( 'wp_enqueue_script' ) as $value ) {
		if ( ( is_admin() && $value['is_admin'] ) || ( ! is_admin() && $value['is_website'] ) ) {

			$has_vars = false;

			if ( isset( $value['vars'] ) && is_array( $value['vars'] ) ) {
				$has_vars = true;
				// replace '-' with '_' in $value['handle'] (for $object_name attribute in wp_localize_script function)
				$value['handle'] = str_replace( '-', '_', $value['handle'] );
			}

			wp_enqueue_script( $value['handle'], $value['src'], $value['deps'], $value['ver'], $value['args'] );

			if ( $has_vars ) {
				wp_localize_script( $value['handle'], $value['handle'] . '_vars', $value['vars'] );
			}
		}
	}

    /**
     * Load css styles
     */
    foreach ( che_general_config( 'wp_enqueue_style' ) as $value ) {
        if((is_admin() && $value['is_admin']) || (!is_admin() && $value['is_website'])){
            wp_enqueue_style( $value['handle'], $value['src'], $value['deps'], $value['ver'], $value['media'] );
        }
    }

}

/**
 * Enqueue scripts and styles.
 */
add_action( 'wp_enqueue_scripts', 'che_wp_enqueue_scripts_theme' );

/**
 * Enqueue scripts and styles in the admin area.
 */
add_action( 'enqueue_block_editor_assets', 'che_wp_enqueue_scripts_theme' );

/**
 * Add combine css file in folder cache
 */
function che_add_combine_css_file_in_folder_cache() {

	if (!THEME_CACHING_CSS || is_user_logged_in() || empty($_SERVER['REQUEST_URI']) || ! defined('CACHE_TIME')) {
		return;
	}

	$requestUri   = parse_url($_SERVER['REQUEST_URI']);
	$path = $requestUri['path'];
	$skipExtensions = ['css', 'map', 'ico', 'js'];
	$fileExtension = pathinfo($path, PATHINFO_EXTENSION);

	if (in_array($fileExtension, $skipExtensions)) {
		return;
	}

	global $wp_styles;

	sort($wp_styles->queue);

	$hash_file_name = md5(json_encode($wp_styles->queue));
	$cache_dir = THEME_CSS_CAHE_DIR;
	$combined_file_name = $hash_file_name . '.min.css';
	$combined_css_path  = $cache_dir . '/' . $combined_file_name;
	$combined_file_name_map = $hash_file_name . '.map';
	$combined_map_path      = $cache_dir . '/' . $combined_file_name_map;

	if (! is_dir($cache_dir) && ! wp_mkdir_p($cache_dir)) {
		return;
	}

	if (! isset($wp_styles) || ! ( $wp_styles instanceof WP_Styles )) {
		return;
	}

	if (file_exists($combined_css_path) && file_exists($combined_map_path)) {
		$mapHandles = json_decode(file_get_contents($combined_map_path), true);
		if (!$mapHandles) {
			return;
		}

		foreach ($wp_styles->queue as $handle) {
			if (!isset($wp_styles->registered[$handle])) {
				continue;
			}

			$style    = $wp_styles->registered[ $handle ];
			$ver = $style->ver;

			if (!empty($mapHandles[$handle]['prev_ver']) && $mapHandles[$handle]['prev_ver'] !== $ver) {
				if (function_exists('rocket_clean_domain')) {
					rocket_clean_domain();
				} else {
					che_clear_theme_css_cache();
				}
				break;
			}
		}
	}

	if (file_exists($combined_css_path)) {
		if (file_exists($combined_map_path)) {
			$handles = array_keys($mapHandles);
		} else {
			$handles = $wp_styles->queue;
		}
		if (! empty($handles)) {
			foreach ($handles as $handle) {
				wp_deregister_style($handle);
			}
		}
	} else {
		$combined_css_content = '';
		$handle_combined      = array();
		$styles = array();

		foreach ($wp_styles->queue as $handle) {
			$style = $wp_styles->registered[ $handle ];
			$style->order = strpos($style->src, '/libs/') !== false ? 0 : 1;
			$styles[] = $style;
		}

		usort($styles, function ($a, $b) {
			return $a->order - $b->order;
		});

		foreach ($styles as $style) {
			$css_path = $style->src;
			$handle = $style->handle;
			$css_content = '';

			if ($handle === 'global-styles') {
				if (! empty($style->extra['after'])) {
					$css_content .= implode("\n", $style->extra['after']);
				}

				if (! empty($style->extra['before'])) {
					$css_content .= implode("\n", $style->extra['before']);
				}
			} elseif (! empty($css_path) && strpos($css_path, 'http') !== 0) {
				$css_path = realpath(ABSPATH . preg_replace('#^' . preg_quote(site_url('/'), '#') . '#', '', $css_path));

				if (file_exists($css_path)) {
					$css_content = file_get_contents($css_path);
				}
			} elseif (! empty($css_path)) {
				if (strpos($css_path, home_url()) !== false) {
					$local_path = str_replace(home_url(), ABSPATH, $css_path);
					$local_path = str_replace('/', DIRECTORY_SEPARATOR, $local_path);

					if (file_exists($local_path)) {
						$css_content = file_get_contents($local_path);
					}
				} else {
					$response = wp_remote_get($css_path);
					if (! is_wp_error($response)) {
						$css_content = wp_remote_retrieve_body($response);
					}
				}
			}

			if (! empty($css_content)) {
				$handle_combined[ $handle ]['ver'] = $style->ver;
				$handle_combined[ $handle ]['prev_ver'] = $style->ver;
				$combined_css_content .= che_replace_css_paths($css_content, $css_path);

				wp_deregister_style($handle);
			}
		}

		if (! empty($combined_css_content)) {
			$combined_css_content = preg_replace('/\/\*[\s\S]*?\*\//', '', $combined_css_content);
			file_put_contents($combined_map_path, json_encode($handle_combined));
			file_put_contents($combined_css_path, $combined_css_content);
		}
	}


	if (file_exists($combined_css_path)) {
		$combined_css_content = file_get_contents($combined_css_path);
		echo "<style id='theme-combined-css' type='text/css'>$combined_css_content</style>";
	}
}
add_action('wp_enqueue_scripts', 'che_add_combine_css_file_in_folder_cache', PHP_INT_MAX);

/**
 * Replace path to assets in combined file
 */
if ( ! function_exists( 'che_replace_css_paths' ) ) {
	function che_replace_css_paths( $css_content, $css_path ) {

		$css_directory = dirname( $css_path );

		return preg_replace_callback( '/url\(\s*([\'"]?)(.+?)\1\s*\)/', function ( $matches ) use ( $css_directory ) {

			$url = $matches[2];
			if ( strpos( $url, '://' ) !== false || strpos( $url, 'data:' ) === 0 ) {
				return $matches[0];
			}

			$new_url = $css_directory . '/' . $url;

			return 'url("' . $new_url . '")';

		}, $css_content );
	}
}

/**
 * Clear theme css cache by get parameter
 *
 */
if (isset($_GET['clear_theme_css'])) {
    //shutdown is the very last hook, so we can't use wp_redirect here since the headers have already been sent
    add_action('shutdown', function () {
        if (function_exists('rocket_clean_domain')) {
            rocket_clean_domain();
        } else {
            che_clear_theme_css_cache();
        }
    });
    //therefore we use JS to redirect
    add_action('wp_footer', function () {
        $url = strtok($_SERVER["REQUEST_URI"], '?');
        echo "<script>window.location.href='" . home_url($url) . "';</script>";
    });
}

/**
 * Clear theme css cache on WP Rocket clear cache
 */
add_action('before_rocket_clean_domain', 'che_clear_theme_css_cache');

/**
 * Clear theme css cache
 *
 * @return void
 */
if (!function_exists('che_clear_theme_css_cache')) {
    function che_clear_theme_css_cache()
    {
        $cache_dir = THEME_CSS_CAHE_DIR;

        if (is_dir($cache_dir)) {
            $files = new RecursiveIteratorIterator(
                new RecursiveDirectoryIterator($cache_dir, RecursiveDirectoryIterator::SKIP_DOTS),
                RecursiveIteratorIterator::CHILD_FIRST
            );

            foreach ($files as $fileinfo) {
                $todo = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
                $todo($fileinfo->getRealPath());
            }
        }
    }
}
